<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Attribute\Route;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\HttpFoundation\Request;
use App\Entity\Estados;
use App\Entity\Paquetes;
use App\Entity\Registros;

#[Route('/api', name: 'api_')]
final class RegistrosController extends AbstractController
{ 
    #[Route('/formulario', name: 'formulario_create', methods:['post'] )]
    public function create(EntityManagerInterface $em, Request $request): JsonResponse
    {
        $registro = new Registros();
        $registro->setNombreEmpresa(mb_strtoupper($request->request->get('nombreEmpresa'), "UTF-8"));
        $registro->setPersonaContacto(mb_strtoupper($request->request->get('personaContacto'), "UTF-8"));
        $registro->setCelular($request->request->get('celular'));
        $registro->setCorreo(strtolower($request->request->get('correo')));
        $registro->setPaquetesId($request->request->get('paquete'));
        $registro->setFechaRegistro(new \DateTime($request->request->get('fechaRegistro')));
        $registro->setDireccionIp($request->request->get('direccionIp'));
        $registro->setEstatus(true);
        $registro->setEstadosId($request->request->get('estado'));
    
        try {
            $em->persist($registro);
            $em->flush();

            $mensaje = [
                'mensaje' => 'Los datos se registraron satisfactoriamente.', 'accion' => true,
            ];
        } catch (\Exception $e) {
            $mensaje = [
                'errores' => 'Oops, ha ocurrido un error en el proceso de registro.', 'accion' => false,
            ];
        }
            
        return new JsonResponse($mensaje);
    }

    #[Route('/estados', name: 'show_estados', methods: ['get'])]
    public function states(EntityManagerInterface $em, Request $reques): JsonResponse
    {
        $estados = $em->getRepository(Estados::class)->findBy(['estatus' => true], ['codigo' => 'ASC']);
        $data = [];
        foreach ($estados as $estado) {
            $data[] =  [
                'id' => $estado->getId(),
                'descripcion' => $estado->getDescripcion(),
            ];
        }
        return new JsonResponse($data);
    }

    #[Route('/paquetes', name: 'show_paquetes', methods: ['get'])]
    public function packages(EntityManagerInterface $em, Request $reques): JsonResponse
    {
        $paquetes = $em->getRepository(Paquetes::class)->findBy(['estatus' => true], ['id' => 'ASC']);
        $data = [];
        foreach ($paquetes as $paquete) {
            $data[] =  [
                'id' => $paquete->getId(),
                'descripcion' => $paquete->getDescripcion(),
            ];
        }
        return new JsonResponse($data);
    }
}
