<?php

namespace App\Entity;

use App\Repository\EstadosRepository;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: EstadosRepository::class)]
class Estados
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 2)]
    private ?string $codigo = null;

    #[ORM\Column(length: 30)]
    private ?string $descripcion = null;

    #[ORM\Column]
    private ?bool $estatus = null;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getCodigo(): ?string
    {
        return $this->codigo;
    }

    public function setCodigo(string $codigo): static
    {
        $this->codigo = $codigo;

        return $this;
    }

    public function getDescripcion(): ?string
    {
        return $this->descripcion;
    }

    public function setDescripcion(string $descripcion): static
    {
        $this->descripcion = $descripcion;

        return $this;
    }

    public function isEstatus(): ?bool
    {
        return $this->estatus;
    }

    public function setEstatus(bool $estatus): static
    {
        $this->estatus = $estatus;

        return $this;
    }
}
