<?php

namespace App\Entity;

use App\Repository\RegistrosRepository;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: RegistrosRepository::class)]
class Registros
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private ?int $id = null;

    #[ORM\Column(length: 150)]
    private ?string $nombreEmpresa = null;

    #[ORM\Column(length: 100)]
    private ?string $personaContacto = null;

    #[ORM\Column(length: 20)]
    private ?string $celular = null;

    #[ORM\Column(length: 60)]
    private ?string $correo = null;

    #[ORM\Column]
    private ?int $paquetesId = null;

    #[ORM\Column(type: Types::DATETIME_MUTABLE)]
    private ?\DateTimeInterface $fechaRegistro = null;

    #[ORM\Column(length: 20)]
    private ?string $direccionIp = null;

    #[ORM\Column]
    private ?bool $estatus = null;

    #[ORM\Column]
    private ?int $estadosId = null;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getNombreEmpresa(): ?string
    {
        return $this->nombreEmpresa;
    }

    public function setNombreEmpresa(string $nombreEmpresa): static
    {
        $this->nombreEmpresa = $nombreEmpresa;

        return $this;
    }

    public function getPersonaContacto(): ?string
    {
        return $this->personaContacto;
    }

    public function setPersonaContacto(string $personaContacto): static
    {
        $this->personaContacto = $personaContacto;

        return $this;
    }

    public function getCelular(): ?string
    {
        return $this->celular;
    }

    public function setCelular(string $celular): static
    {
        $this->celular = $celular;

        return $this;
    }

    public function getCorreo(): ?string
    {
        return $this->correo;
    }

    public function setCorreo(string $correo): static
    {
        $this->correo = $correo;

        return $this;
    }

    public function getPaquetesId(): ?int
    {
        return $this->paquetesId;
    }

    public function setPaquetesId(int $paquetesId): static
    {
        $this->paquetesId = $paquetesId;

        return $this;
    }

    public function getFechaRegistro(): ?\DateTimeInterface
    {
        return $this->fechaRegistro;
    }

    public function setFechaRegistro(\DateTimeInterface $fechaRegistro): static
    {
        $this->fechaRegistro = $fechaRegistro;

        return $this;
    }

    public function getDireccionIp(): ?string
    {
        return $this->direccionIp;
    }

    public function setDireccionIp(string $direccionIp): static
    {
        $this->direccionIp = $direccionIp;

        return $this;
    }

    public function isEstatus(): ?bool
    {
        return $this->estatus;
    }

    public function setEstatus(bool $estatus): static
    {
        $this->estatus = $estatus;

        return $this;
    }

    public function getEstadosId(): ?int
    {
        return $this->estadosId;
    }

    public function setEstadosId(int $estadosId): static
    {
        $this->estadosId = $estadosId;

        return $this;
    }
}
